//  
//  Animacion.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 08-Sep-1996  04:10:25
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.applet.Applet;

public class Animacion extends Applet implements Runnable {
    Image imagenes[];
    MediaTracker tracker;
    int indice = 0;
    Thread animacion;

    int maxAncho,maxAlto;
    Image offScrImage; // Componente off-screen para doble buffering
    Graphics offScrGC;

    // Nos indicar si ya se puede pintar
    boolean cargado = false;

    // Inicializamos el applet, establecemos su tamao y
    // cargamos las imgenes
    public void init() {
		// Establecemos el supervisor de imgenes
        tracker = new MediaTracker( this );
        // Fijamos el tamao del applet
        maxAncho = 100;
        maxAlto = 100;
        imagenes = new Image[18];

        // Establecemos el doble buffer y dimensionamos el applet
        try {
            offScrImage = createImage( maxAncho,maxAlto );
            offScrGC = offScrImage.getGraphics();
            offScrGC.setColor( Color.lightGray );
            offScrGC.fillRect( 0,0,maxAncho,maxAlto );
            resize( maxAncho,maxAlto );
        } catch( Exception e ) {
            e.printStackTrace();
            }

        // Cargamos las imgenes en un array
        for( int i=0; i < 18; i++ )
            {
            String fichero = 
                new String( "tierra"+String.valueOf(i+1)+".gif" );
            imagenes[i] = getImage( getDocumentBase(),fichero );
            // Registramos las imgenes con el tracker
            tracker.addImage( imagenes[i],i );
            showStatus( "Cargando Imagen: "+fichero );
            }
        showStatus( "" );

        try {
            // Utilizamos el tracker para comprobar que todas las
            // imgenes estn cargadas
            tracker.waitForAll();
        } catch( InterruptedException e ) {
            ;
            }
        cargado = true;
        }

    // Pintamos el fotograma que corresponda
    public void paint( Graphics g ) {
        if( cargado )
            g.drawImage( offScrImage,0,0,this );
        }

    // Arrancamos y establecemos la primera imagen
    public void start() {
        if( tracker.checkID( indice ) )
            offScrGC.drawImage( imagenes[indice],0,0,this );
        animacion = new Thread( this );
        animacion.start();
        }
    
    // Aqu hacemos el trabajo de animacin
    // Muestra una imagen, para, muestra la siguiente...
    public void run() {
        // Obtiene el identificador del thread
        Thread thActual = Thread.currentThread();

        // Nos aseguramos de que se ejecuta cuando estamos en un thread
        // y adems es el actual
        while( animacion != null  &&  animacion == thActual )
            {
            if( tracker.checkID( indice ) )
                {
                // Obtenemos la siguiente imagen
                offScrGC.drawImage( imagenes[indice],0,0,this );
                indice++;
                // Volvemos al principio y seguimos, para el bucle
                if( indice >= imagenes.length )
                    indice = 0;
                }

            // Ralentizamos la animacin para que parezca normal
            try {
                animacion.sleep( 200 );
            } catch( InterruptedException e ) {
                ;
                }
            // Pintamos el siguiente fotograma
            repaint();
		    }
        }	  
    }

//----------------------------------------- Final del fichero Animacion.java
