//  
//  Figuras.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 04-Jun-1996  06:26:10
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y est sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.applet.Applet;
import java.lang.Math;
import java.util.Random;

// Es un applet muy simple para demostrar el multithreading
// Crea crculos, corriendo cada uno en su propio thread
// que se ir agrandando y disminuyendo ms o menos 
// rpidamente
public class Figuras extends Applet {
    public int Ancho = 400;
    public int Alto = 100;
    public int Numero = 15;
    public final int minTam = 10;
    public final int maxTam = 50;
    public final int minNaptime = 1;
    public final int maxNaptime = 500;

    public final Color colores[] = {
        Color.red,
        Color.pink,
        Color.orange,
        Color.yellow,
        Color.green,
        Color.magenta,
        Color.blue,
        Color.cyan,
        Color.white,
        Color.gray,
        Color.lightGray,
        Color.darkGray
        };

    public final Color bg = Color.black;
    boolean thSuspendida = false;
    Image im;
    Graphics offscreen;
    Random rand;
    Circulo circulos[] = new Circulo[Numero];
        

    public void init() {
        resize( Ancho,Alto );
        rand = new Random( (long)System.currentTimeMillis() );
        try {
            im = createImage( Ancho,Alto );
            offscreen = im.getGraphics();
        } catch( Exception e ) {
            offscreen = null;
            }
        }


    // Creamos cada figura con algunos parmetros aleatorios y
    // arrancamos su thread
    public void start() {
        for( int i=0; i < Numero; i++ ) 
            {
            if( circulos[i] == null ) 
                {
                circulos[i] = new Circulo( this,
                    (int)( (double)Ancho * rand.nextDouble() ),
                    (int)((double)Alto * rand.nextDouble() ),
                    minTam + 
                    (int)( (double)(maxTam-minTam) * rand.nextDouble() ),
                    minNaptime + 
                    (int)( (double)(maxNaptime-minNaptime) * rand.nextDouble() ),
                    colores[(int)( (double)colores.length * rand.nextDouble() )],
                    bg );
                circulos[i].start();
                }
            }
        repaint();
        }


    // Cuando detengamos el applet, paramos todos los threads
    public void stop() {
        for( int i=0; i < Numero; i++ ) 
            circulos[i].stop();
        }
        

    // Sobrecargamos el metodo update para reducir el flasheo
    public void update( Graphics g ) {
        paint( g );
        }
        

    // Utilizamos tambin el doble-buffer para reducir el flasheo
    // de la imagen en la pantalla
    public void paint( Graphics g ) {
        if( offscreen != null ) 
            {
            paintApplet( offscreen );
            g.drawImage( im,0,0,this );
            } 
        else
            paintApplet( g );
        }

        
    // Llamamos al metodo paint de cada una de las figuras
    public void paintApplet( Graphics g ) {
        g.setColor( bg );
        g.fillRect( 0,0,Ancho,Alto );
        for( int i=0; i < Numero; i++ ) 
            circulos[i].paint( g );
        }
    

    // Respondiendo al ratn, suspendemos o resumimos el
    // thread de cada una de la figuras
    public boolean mouseDown( Event evt,int x,int y ) {
        if( thSuspendida ) 
            {
            for( int i=0; i < Numero; i++ )
                circulos[i].thread.resume();
            } 
        else 
            {
            for( int i=0; i < Numero; i++ )
                circulos[i].thread.suspend();
            }
        thSuspendida = !thSuspendida;

        return( true );
        }
    }                                 



// Implementamos un crculo. Cada figura llamar a su metodo
// paint asncronamente cuando le llegue el momento de
// aumentar o disminuir su dimensin
class Circulo implements Runnable {
    static int threadNum = 1;
    private Color color = null;
    private Color bg = Color.black;
    private int naptime = 500;
    private int tamano = 50;
    private int factorCrecer = 1;
    private int ox = 0;    /* posicin dentro del frame */
    private int oy = 0;
    private Graphics graphics;
    private int actual;
    private int anterior;
    private boolean creciendo = false;
    public Thread thread = null;
    Figuras applet;

    public Circulo( Figuras applet,int x,int y,int s,int n,
        Color c,Color bg ) {
        this.applet = applet;
        ox = x;
        oy = y;
        tamano = s;
        naptime = n;
        color = c;
        if( color == null )
        color = Color.black;
        actual = anterior = s;
        }
        

    public void run() {
        thread.setPriority( Thread.MIN_PRIORITY+1 );
        while( thread != null ) 
            {
            anterior = actual;
            if( creciendo )
                actual += factorCrecer;
            else
                actual -= factorCrecer;
        
            if( actual == tamano || actual == 0 ) 
                creciendo = !creciendo;
        
            try { 
                thread.sleep( naptime ); 
            } catch( InterruptedException e ) 
                {
                ;
                }
            applet.repaint();
            }
        thread = null;
        }
        

    public void start() {
        if( thread == null ) 
            {
            thread = new Thread( this,Integer.toString( threadNum++ ) );
            thread.start();
            }
        }
        

    public void stop() {
        thread = null;
        }
       

    // Borramos la antigua posicin y pintamos la nueva
    public void paint( Graphics g ) {
        int antMedio = (int)( anterior/2 );
        int actMedio = (int)( actual/2 );

        g.setColor( bg );
        g.fillOval( ox-antMedio,oy-antMedio,anterior,anterior );
   
        g.setColor( color);
        g.fillOval( ox-actMedio,oy-actMedio,actual,actual );
        }
    }

//------------------------------------------- Final del fichero Figuras.java
