//  
//  Agenda.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 06-Oct-1996  09:48:03
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.io.*;

class Direccion {
    protected String nombre;
    protected String telefono;
    protected String direccion;

    Direccion( String n,String t,String d ) {
        nombre = n;
        telefono = t;
        direccion = d;
        }

    public String getNombre() {
        return( nombre );
        }

    public String getTelefono() {
        return( telefono );
        }

    public String getDireccion() {
        return( direccion );
        }

    public void print() {
        System.out.println( nombre+"\n  "+telefono+"\n  "+
            direccion );
        }
    }


class DireccionArray {
    protected Direccion lista[];
    final int max = 128;
    int tamano = 0;

    DireccionArray() {
        lista = new Direccion[max];
        }

    void printDireccion( String nombre ) {
        for(int i=0; i < tamano; i++ )
            {
            if( lista[i].getNombre().indexOf( nombre ) != -1 )
                lista[i].print();
            }
        }

    void addDireccion( Direccion direccion ) {
        if( tamano == max )
            System.exit( 1 );
        lista[tamano++] = direccion;
        }
    }


public class Agenda {
    DireccionArray lista;
    FileInputStream agFichero;
    final int longLinea = 32;

    public static void main( String argv[] ) {
        Agenda agenda = new Agenda();
        agenda.bucle();
        }

    Agenda() {
        lista = cargaDirecciones();
        }

    void bucle() {
        String nombre;

        System.out.println( "Introduzca un nombre o <Enter>" );
        try {
            while( !"".equals( nombre = leeEntrada( System.in ) ) )
                {
                lista.printDireccion( nombre );
                System.out.println(
                    "Introduzca un nombre o <Enter>" );
                }
        } catch( Exception e ) {
            ;
            }
        }

    String leeEntrada( InputStream entrada ) throws IOException {
        byte chars[] = new byte[longLinea];
        int contador = 0;

        while( contador < longLinea &&
            ( chars[contador++] = (byte)entrada.read() ) != '\n' )
            if( chars[contador-1] == -1 )
                return( null );
    
        return( new String( chars,0,0,contador-1 ) );
        }

    Direccion cargaDireccion() throws IOException {
        String nombre = leeEntrada( agFichero );
        if( nombre == null )
            return( null );

        String telefono = leeEntrada( agFichero );
        String direccion = leeEntrada( agFichero ) + "\n  " +
            leeEntrada( agFichero ) + "\n  " +
            leeEntrada( agFichero );

        return( new Direccion( nombre,telefono,direccion ) );
        }

    DireccionArray cargaDirecciones() {
        DireccionArray lista = new DireccionArray();
        Direccion nuevaDireccion;

        try {
            agFichero = new FileInputStream( "agenda" );
        } catch( FileNotFoundException e ) {
            System.out.println( "No hay fichero de Agenda" );
            return( lista );
            }

        while( true ) {
            try {
                nuevaDireccion = cargaDireccion();
                if( nuevaDireccion == null )
                    return( lista );
                lista.addDireccion( nuevaDireccion );
            } catch( Exception e ) {
                System.out.println( "Error cargando Agenda " );
                System.exit( 1 );
                }
            }
        }
    }

//-------------------------------------------- Final del fichero Agenda.java
