//  
//  clienteUDP.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 30-Sep-1996  15:07:49
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.net.*;
import java.io.*;
import sun.net.*;

// Implementacin del cliente de datagramas UDP. Devuelve la salida
// de los servidores
//
class clienteUDP {
    public static void main( String args[] ) {
        int longitud = 100;
        DatagramSocket s = (DatagramSocket)null;
        DatagramPacket enviap,recibep;
        byte ibuffer[] = new byte[100];
        InetAddress IP = (InetAddress)null;
        int puertoEnvio = 4321;
        int puertoRecep = 4322;

        // Abre una conexin y establece el cliente para recibir
        // una peticin en el socket 4321
        try {
            s = new DatagramSocket( puertoRecep );
        } catch( SocketException e ) {
            System.out.println( "Error - "+e.toString() );
            }

        // Crea una peticin para enviar bytes. Intenta conseguir
        // la direccin IP del host
        try {
            IP = InetAddress.getByName( "breogan" );
        } catch( UnknownHostException e ) {
            System.out.println( "No encuentro el host breogan" );
            System.exit( -1 );
            }
 
        // Enva una peticin para que responda el servidor
        try {
            enviap = new DatagramPacket( ibuffer,ibuffer.length,IP,4322 );
            s.send( enviap );
        } catch( IOException e ) {
            System.out.println( "Error - "+e.toString() );
            }

        // Consigue un controlador de fichero de entrada del socket y lee
        // dicha entrada. Creamos un paquete descriptor para recibir el
        // paquete UDP
        recibep = new DatagramPacket( ibuffer,longitud );

        // Espera a recibir un paquete
        try {
            s.receive( recibep );
        } catch( IOException e ) {
            System.out.println( "Error - "+e.toString() );
            System.exit( -1 );
            }

        // Imprimimos los resultados de lo que conseguimos
        System.out.println( "Recibido: "+recibep.getLength()+" bytes" );
        String datos = new String( recibep.getData(),0 );
        System.out.println( "Datos: "+datos );
        System.out.println( "Recibido por el puerto: "+recibep.getPort() );

        // Cerramos la conexin y abandonamos
        s.close();
        }
    } 

//---------------------------------------- Final del fichero clienteUDP.java
