//  
//  servidorUDP.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 30-Sep-1996  15:42:04
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.net.*;
import java.io.*;
import sun.net.*;

// Implementacin del servidor de datagramas UDP. Enva una cadena
// tras peticin
//
class servidorUDP {
    public static void main( String args[] ) {
        DatagramSocket s = (DatagramSocket)null;
        DatagramPacket enviap,recibep;
        byte ibuffer[] = new byte[100];
        String cadena = "Hola Tutorial de java!\n";
        InetAddress IP = (InetAddress)null;
        int longitud = cadena.length();
        int puertoEnvio = 4321;
        int puertoRecep = 4322;
        int puertoRemoto;

        // Intentamos conseguir la direccin IP del host
        try {
            IP = InetAddress.getByName( "breogan" );
        } catch( UnknownHostException e ) {
            System.out.println( "No encuentro el host breogan" );
            System.exit( -1 );
            }

        // Establecemos el servidor para escuchar en el socket 4322
        try {
            s = new DatagramSocket( puertoRecep );
        } catch( SocketException e ) {
            System.out.println( "Error - "+e.toString() );
            }

        // Creamos un paquete de solicitud en el cliente
        // y nos quedamos esperando a sus peticiones
        recibep = new DatagramPacket( ibuffer,longitud );
        try {
            s.receive( recibep );
        } catch( IOException e ) {
            System.out.println( "Error - "+e.toString() );
            }

        // Creamos un paquete para enviar al cliente y lo enviamos
        cadena.getBytes( 0,longitud,ibuffer,0 );
        enviap = new DatagramPacket( ibuffer,longitud,IP,puertoEnvio );
        try {
            s.send( enviap );
        } catch( IOException e ) {
            System.out.println( "Error - "+e.toString() );
            System.exit( -1 );
            }

        // Cerramos el socket
        s.close();
        }
    } 

//--------------------------------------- Final del fichero servidorUDP.java
