//  
//  smtpCliente.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 28-11-1996  04:08:24
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.net.*;
import java.io.*;

class smtpCliente {
    public static void main( String args[] ) {
        Socket s = null;
        DataInputStream sIn = null;
        DataOutputStream sOut = null;

        // Abrimos una conexin con breogan en el puerto 25
        // que es el correspondiente al proticolo smtp, e intentamos
        // abrir los streams de entrada y salida
        try {
            s = new Socket( "breogan",25 );
            sIn = new DataInputStream( s.getInputStream() );
            sOut = new DataOutputStream( s.getOutputStream() );
        } catch( UnknownHostException e ) {
            System.out.println( "No conozco el host" );
        } catch( IOException e ) {
            System.out.println( e );
            }

        // Si todo est inicializado correctamente, vamos a escribir
        // algunos datos en el canal de salida que se ha establecido
        // con el puerto del protocolo smtp del servidor
        if( s != null && sIn != null && sOut != null )
            {
            try {
                // Tenemos que respetar la especificacin SMTP dada en
                // RFC1822/3, de forma que lo que va en maysculas
                // antes de los dos puntos tiene un significado especial
                // en el protocolo
                sOut.writeBytes( "MAIL From: froufe@arrakis.es\n" );
                sOut.writeBytes( "RCPT To: froufe@arrakis.es\n" );
                sOut.writeBytes( "DATA\n" );
                sOut.writeBytes( "From: froufe@arrakis.es\n" );
                sOut.writeBytes( "Subject: Pruebas\n" );
                // Ahora el cuerpo del mensaje
                sOut.writeBytes( "Hola, desde el Tutorial de Java\n" );
                sOut.writeBytes( "\n.\n" );

                // Nos quedamos a la espera de recibir el "Ok" del
                // servidor para saber que ha recibido el mensaje
                // correctamente, momento en el cual cortamos

                String respuesta;
                while( ( respuesta = sIn.readLine() ) != null )
                    {
                    System.out.println( "Servidor: "+respuesta );
                    if( respuesta.indexOf( "Ok" ) != -1 )
                        break;
                    }

                // Cerramos todo lo que hemos abierto
                sOut.close();
                sIn.close();
                s.close();
              } catch( UnknownHostException e ) {
                System.out.println( "Intentando conectar: "+e );
            } catch( IOException e ) {
                System.out.println( e );
                }
            }
        }
    }

//--------------------------------------- Final del fichero smtpCliente.java
