/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;

public class IntlWindow
extends Frame
implements WindowListener {
    private boolean inAnApplet = true;
    private Applet parentApplet;
    Panel cards;
    private Locale currentLocale;
    private Locale[] supportedLocales = new Locale[]{Locale.US, Locale.FRANCE, Locale.CANADA_FRENCH};
    private Image[] flags;
    private FlagCanvas[] flagCanvases;
    private int selectedFlag = -1;
    private Image[] soundImages;
    private String[] soundNames = new String[]{"book", "car", "dog", "apple"};
    private Font defaultFont;
    private Font boldFont;

    public IntlWindow() {
        this.currentLocale = this.getLocale();
        int n = 0;
        while (n < this.supportedLocales.length) {
            if (this.currentLocale == this.supportedLocales[n]) {
                this.selectedFlag = n;
            }
            ++n;
        }
        if (this.selectedFlag == -1) {
            this.currentLocale = this.supportedLocales[0];
            this.selectedFlag = 0;
        }
        this.setTitle("AroundTheWorld");
        this.createGUIElements();
        this.addWindowListener(this);
    }

    public static void main(String[] stringArray) {
        IntlWindow intlWindow = new IntlWindow();
        intlWindow.inAnApplet = false;
        intlWindow.pack();
        intlWindow.show();
    }

    public void selectFlag(FlagCanvas flagCanvas) {
        int n = 0;
        while (n < this.flagCanvases.length) {
            if (flagCanvas == this.flagCanvases[n]) {
                this.selectedFlag = n;
                this.flagCanvases[n].setSelected(true);
            } else {
                this.flagCanvases[n].setSelected(false);
            }
            ++n;
        }
        this.currentLocale = this.supportedLocales[this.selectedFlag];
        ((CardLayout)this.cards.getLayout()).show(this.cards, this.currentLocale.getDisplayName());
        this.doLayout();
    }

    public Applet getApplet() {
        return this.parentApplet;
    }

    public void setApplet(Applet applet) {
        this.parentApplet = applet;
        this.inAnApplet = true;
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.inAnApplet) {
            this.dispose();
            return;
        }
        System.exit(0);
    }

    private void createGUIElements() {
        Object object;
        this.defaultFont = new Font("Helvetica", 0, 14);
        this.boldFont = new Font(this.defaultFont.getName(), 1, this.defaultFont.getSize());
        ((Component)this).setFont(this.defaultFont);
        MediaTracker mediaTracker = new MediaTracker(this);
        this.flags = new Image[this.supportedLocales.length];
        this.flagCanvases = new FlagCanvas[this.supportedLocales.length];
        int n = 0;
        while (n < this.supportedLocales.length) {
            String string = "flag_" + this.supportedLocales[n].toString() + ".gif";
            try {
                object = this.getClass().getResource(string);
                this.flags[n] = Toolkit.getDefaultToolkit().getImage((URL)object);
            }
            catch (Exception exception) {
                System.err.println("Couldn't load flag image: " + string);
                exception.printStackTrace();
            }
            mediaTracker.addImage(this.flags[n], n);
            ++n;
        }
        this.soundImages = new Image[this.soundNames.length];
        int n2 = 0;
        while (n2 < this.soundNames.length) {
            object = String.valueOf(this.soundNames[n2]) + ".gif";
            try {
                URL uRL = this.getClass().getResource((String)object);
                this.soundImages[n2] = Toolkit.getDefaultToolkit().getImage(uRL);
            }
            catch (Exception exception) {
                System.err.println("Couldn't load sound image: " + (String)object);
                exception.printStackTrace();
            }
            mediaTracker.addImage(this.soundImages[n2], n2 + this.supportedLocales.length);
            ++n2;
        }
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("exception from tracker");
            interruptedException.printStackTrace();
        }
        object = new Panel();
        ((Container)object).setLayout(new FlowLayout());
        int n3 = 0;
        while (n3 < this.flags.length) {
            this.flagCanvases[n3] = new FlagCanvas(this.flags[n3], this, this.flags[n3].getWidth(this), this.flags[n3].getHeight(this));
            ((Container)object).add(this.flagCanvases[n3]);
            ++n3;
        }
        this.flagCanvases[this.selectedFlag].setSelected(true);
        this.add("North", (Component)object);
        this.cards = new Panel();
        this.cards.setLayout(new CardLayout());
        int n4 = 0;
        while (n4 < this.supportedLocales.length) {
            LinguaPanel linguaPanel = null;
            try {
                linguaPanel = new LinguaPanel(this.supportedLocales[n4], this.inAnApplet, this.defaultFont, this.boldFont, this.soundImages, this.soundNames);
            }
            catch (MissingResourceException missingResourceException) {
                System.out.println("Couldn't load resource(s).");
            }
            this.cards.add(this.supportedLocales[n4].getDisplayName(), linguaPanel);
            ++n4;
        }
        this.add("Center", this.cards);
    }
}

