/*
 * Decompiled with CFR 0.152.
 */
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

class LinguaPanel
extends Panel {
    private Label localeLabel;
    private Label localeValue;
    private Label dateLabel;
    private Label dateValue;
    private Date date;
    private DateFormat dateFormatter;
    private Label gdpLabel;
    private Label gdpValue;
    private Double gdp;
    private NumberFormat gdpFormatter;
    private Label populationLabel;
    private Label populationValue;
    private Integer population;
    private NumberFormat populationFormatter;
    private Label literacyLabel;
    private Label literacyValue;
    private Double literacy;
    private NumberFormat literacyFormatter;
    private TextArea description;
    private SoundCanvas[] soundCanvases;
    private Panel soundPanel;
    private Font defaultFont;
    private Font boldFont;

    LinguaPanel(Locale locale, boolean bl, Font font, Font font2, Image[] imageArray, String[] stringArray) throws MissingResourceException {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("LabelsBundle", locale);
        ResourceBundle resourceBundle2 = ResourceBundle.getBundle("ParagraphBundle", locale);
        ResourceBundle resourceBundle3 = ResourceBundle.getBundle("NumbersBundle", locale);
        MediaBundle mediaBundle = (MediaBundle)ResourceBundle.getBundle("FlagNSoundsBundle", locale);
        mediaBundle.trackMedia(this);
        this.localeLabel = new Label();
        this.localeLabel.setFont(font2);
        this.localeValue = new Label();
        this.add(this.localeLabel);
        this.add(this.localeValue);
        Calendar calendar = Calendar.getInstance();
        this.date = calendar.getTime();
        this.dateLabel = new Label();
        this.dateLabel.setFont(font2);
        this.dateValue = new Label();
        this.add(this.dateLabel);
        this.add(this.dateValue);
        this.gdpLabel = new Label();
        this.gdpLabel.setFont(font2);
        this.gdpValue = new Label();
        this.add(this.gdpLabel);
        this.add(this.gdpValue);
        this.populationLabel = new Label();
        this.populationLabel.setFont(font2);
        this.populationValue = new Label();
        this.add(this.populationLabel);
        this.add(this.populationValue);
        this.literacyLabel = new Label();
        this.literacyLabel.setFont(font2);
        this.literacyValue = new Label();
        this.add(this.literacyLabel);
        this.add(this.literacyValue);
        this.soundPanel = new Panel();
        this.soundPanel.setLayout(new FlowLayout());
        this.soundCanvases = new SoundCanvas[imageArray.length];
        int n = 0;
        while (n < this.soundCanvases.length) {
            this.soundCanvases[n] = bl ? new SoundCanvas(imageArray[n], this, imageArray[n].getHeight(this), imageArray[n].getWidth(this), mediaBundle.getString(stringArray[n])) : new SoundCanvas(imageArray[n], this, imageArray[n].getHeight(this), imageArray[n].getWidth(this), null);
            this.soundPanel.add(this.soundCanvases[n]);
            ++n;
        }
        this.add(this.soundPanel);
        this.description = new TextArea(resourceBundle2.getString("LocaleDescription"), 7, 10, 1);
        this.description.setEditable(false);
        this.add(this.description);
        this.localeLabel.setText(resourceBundle.getString("LocaleLabel"));
        this.localeValue.setText(locale.getDisplayName(locale));
        this.dateLabel.setText(resourceBundle.getString("DateLabel"));
        this.dateFormatter = DateFormat.getDateInstance(2, locale);
        this.dateValue.setText(this.dateFormatter.format(this.date));
        this.gdpLabel.setText(resourceBundle.getString("GDPLabel"));
        this.gdpFormatter = NumberFormat.getCurrencyInstance(locale);
        this.gdp = (Double)resourceBundle3.getObject("GDP");
        this.gdpValue.setText(this.gdpFormatter.format(this.gdp));
        this.populationLabel.setText(resourceBundle.getString("PopulationLabel"));
        this.populationFormatter = NumberFormat.getNumberInstance(locale);
        this.population = (Integer)resourceBundle3.getObject("Population");
        this.populationValue.setText(this.populationFormatter.format(this.population));
        this.literacyLabel.setText(resourceBundle.getString("LiteracyLabel"));
        this.literacyFormatter = NumberFormat.getPercentInstance(locale);
        this.literacy = (Double)resourceBundle3.getObject("Literacy");
        this.literacyValue.setText(this.literacyFormatter.format(this.literacy));
        this.layoutGUI();
    }

    private void layoutGUI() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.localeLabel, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.localeValue, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.dateLabel, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.dateValue, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.gdpLabel, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.gdpValue, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.populationLabel, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.populationValue, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.literacyLabel, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.literacyValue, gridBagConstraints);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.soundPanel, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.description, gridBagConstraints);
    }
}

