/*
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
package acme.beans;

import java.awt.*;
import java.io.Serializable;


public class Acme04Bean extends Canvas implements Serializable {

    public Acme04Bean() {
        setSize(60,40);
        this.label="Bean";
        setFont(new Font("Dialog", Font.PLAIN, 12));
    }

    public void paint(Graphics g) {
        g.setColor(beanColor);
        g.fillRect(20, 5, 20, 30);
        g.fillArc(5, 5, 30, 30, 0, 360);
        g.fillArc(25, 5, 30, 30, 0, 360);
        g.setColor(Color.blue);

        int width = getSize().width;
        int height = getSize().height;
        FontMetrics fm = g.getFontMetrics();
        g.drawString(label, (width - fm.stringWidth(label)) / 2, 
                          (height + fm.getMaxAscent() - fm.getMaxDescent()) / 2);
    }

    public Color getColor() {
        return beanColor;
    }

    public void setColor(Color newColor) {
        beanColor = newColor;
        repaint();
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String newLabel) {
        String oldLabel = label;
        label = newLabel;
    }

    private Color beanColor = Color.cyan;
    private String label;
}
