/*
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
package acme.beans;

import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.Serializable;
import java.util.Vector;


public class Acme09Bean extends Canvas implements Serializable {


    public Acme09Bean() {
        this("Acme Bean Counter:");
    }

    public Acme09Bean(String label) {
        super();
        // this.label = label + "X " + count;
        updateLabel();
        setFont(new Font("Dialog", Font.PLAIN, 12));
    }

    public synchronized void paint(Graphics g) {

        int width = getSize().width;
        int height = getSize().height;

        g.setColor(beanColor);
        g.fillRect(1, 1, width - 2, height - 2);
        g.draw3DRect(0, 0, width - 1, height - 1, !down);

        g.setColor(getForeground());
        g.setFont(getFont());

        g.drawRect(2, 2, width - 4, height - 4);

        FontMetrics fm = g.getFontMetrics();
        g.drawString(label, (width - fm.stringWidth(label)) / 2, 
                          (height + fm.getMaxAscent() - fm.getMaxDescent()) / 2);
    }

    public void updateLabel() {
      //label = label + " " + count;
        label = (new Integer(count)).toString();
    }

    public void fireAction() {
        if (debug) {
          //System.err.println("Button " + getLabel() + " pressed.");
            System.err.println("Button " + label + " pressed.");
        }
        Vector targets;
        synchronized (this) {
            targets = (Vector) listeners.clone();
        }
        ActionEvent actionEvt = new ActionEvent(this, 0, null);
        for (int i = 0; i < targets.size(); i++) {
            ActionListener target = (ActionListener)targets.elementAt(i);
            target.actionPerformed(actionEvt);
        }

        Component parent = getParent();
        if (parent != null) {
            parent.postEvent(new Event(this, Event.MOUSE_DOWN, null));
        }
    }

    public void setDebug(boolean x) {
        boolean old = debug;
        debug = x;
    }

    public boolean getDebug() {
        return debug;
    }

    public Color getColor() {
        return beanColor;
    }

    public void setColor(Color newColor) {
        beanColor = newColor;
        repaint();
    }
  /*
   * Tue Dec 17 21:24:45 1996
   *
   * Remove label property
   * Still used in Bean, just can't
   * set it externally, either by method call
   * or Builder tool event hookup.
    public String getLabel() {
        return label;
    }

    public void setLabel(String newLabel) {
        String oldLabel = label;
        label = newLabel;
        sizeToFit();
    }
    */
    public int getCount() {
        return count;
    }

    public void setCount(int newCount) {
        int oldCount = count;
        count = newCount;
        sizeToFit();
    }

    public Dimension getPreferredSize() {
        FontMetrics fm = getFontMetrics(getFont());
        return new Dimension(fm.stringWidth(label) + TEXT_XPAD, 
                             fm.getMaxAscent() + fm.getMaxDescent() + TEXT_YPAD);
    }

    public Dimension getMinimumSize() {
        return getPreferredSize();
    }

    private void sizeToFit() {
        Dimension d = getPreferredSize();
        setSize(d.width, d.height);
        Component p = getParent();
        if (p != null) {
            p.invalidate();
            p.doLayout();
        }
    }

    public boolean handleEvent(Event evt) {
        if (! isEnabled()) {
            return false;
        }
        switch (evt.id) {
        case Event.MOUSE_DOWN:
            down = true;
            repaint();
            return true;
        case Event.MOUSE_UP:
            if (down) {
                fireAction();
                down = false;
                repaint();
            }
            return true;
        }
        return false;
    }

    public synchronized void addActionListener(ActionListener l) {
        listeners.addElement(l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        listeners.removeElement(l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        changes.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        changes.removePropertyChangeListener(l);
    }

    public void incrementCount(ActionEvent x) {
        count++;
        updateLabel();
        sizeToFit();
    }

    public void decrementCount(ActionEvent x) {
        count--;
        updateLabel();
        sizeToFit();
    }


  // temp, called by TestAcme09Bean.java
    public void incrementCount() {
        count++;
        updateLabel();
        sizeToFit();
        repaint();
    }

  // temp, called by TestAcme09Bean.java
    public void decrementCount() {
        count--;
        updateLabel();
        sizeToFit();
        repaint();
    }


    private int count = 1;
    private boolean debug = true;
    private Color beanColor = Color.cyan;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private Vector listeners = new Vector();
    private String label;
    private boolean down;
    static final int TEXT_XPAD = 12;
    static final int TEXT_YPAD = 8;
}
