/*
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import acme.beans.Acme08Bean;
import java.awt.*;
import java.applet.*;

public class TestAcme08Bean extends Applet
{
   String msgStr;
   private Acme08Bean b;

   public void init()
   {
     b = new Acme08Bean();
     add(b);
      setFont(new Font("TimesRoman", Font.BOLD, 24));
      msgStr = "Press any key...";
      setForeground(Color.blue);
      add(new Button("make action event"));
      setSize(400,200);
   }

   public void start()
   {
      requestFocus();
   }

   public boolean keyDown(Event e,  int key)
   {
      msgStr = "\"" + (char)key + "\"" + " key pressed";
      if ((char)key == 'q') {
        System.exit(0);
        System.out.println("Got a 'q'");
      }
      repaint();
      return true;
   }

   public boolean keyUp(Event e,  int key)
   {
      msgStr = "\"" + (char)key + "\"" + " key released";
      repaint();
      return true;
   }

   public boolean gotFocus(Event e,  Object arg)
   {
      msgStr = "Got Focus";
      if (arg!= null)
         msgStr = msgStr + " arg: " + arg.toString();
      repaint();
      return true;
   }

   public boolean lostFocus(Event e,  Object arg)
   {
      msgStr = "Lost Focus" ;
      if (arg != null)
         msgStr = msgStr + " arg: " + arg.toString();
      repaint();
      return true;
   }

   public boolean action(Event e,  Object arg)
   {
      msgStr = "Action Event." ;
      if (arg != null)
         msgStr = msgStr + " Arg: " + arg.toString();
      repaint();
      return true;
   }

   public void paint(Graphics g)
   {
      FontMetrics currFM = g.getFontMetrics();
      g.drawString(msgStr, ( getSize().width -
      currFM.stringWidth(msgStr)) / 2,
      (getSize().height- currFM.getHeight())/ 2 +
      currFM.getLeading() + currFM.getAscent());
    }

}
