/*
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.awt.*;
import java.awt.event.*;
import java.util.Locale;

import java.applet.Applet;
import java.net.URL;
import java.awt.image.ImageProducer;
import java.awt.Toolkit;

public class IntlWindow extends Frame implements WindowListener {
    private boolean inAnApplet = true;
    private Applet parentApplet = null;

    Panel cards;

    private Locale currentLocale;
    private Locale[] supportedLocales = {
	Locale.US,
	Locale.FRANCE,
	Locale.CANADA_FRENCH
    };

    private Image[] flags;
    private FlagCanvas[] flagCanvases;
    private int selectedFlag = -1;

    private Image[] soundImages;
    private String[] soundNames = { "book", "car", "dog", "apple" };

    private Font defaultFont;
    private Font boldFont;

    public IntlWindow() {

	currentLocale = getLocale();

	for (int i = 0; i < supportedLocales.length; i++) {
	    if (currentLocale == supportedLocales[i])
		selectedFlag = i;
	}

	if (selectedFlag == -1) {
	    currentLocale = supportedLocales[0];
	    selectedFlag = 0;
	}

        setTitle("AroundTheWorld");
	createGUIElements();
	addWindowListener(this);
    }


    public static void main(String[] args) {
        IntlWindow window = new IntlWindow();
        window.inAnApplet = false;

        window.pack();
        window.show();
    }

    public void selectFlag(FlagCanvas f) {
	for (int i = 0; i < flagCanvases.length; i++) {
	    if (f == flagCanvases[i]) {
		selectedFlag = i;
		flagCanvases[i].setSelected(true);
	    } else
	        flagCanvases[i].setSelected(false);
	}
	currentLocale = supportedLocales[selectedFlag];
	((CardLayout)cards.getLayout()).show(cards, currentLocale.getDisplayName());
	doLayout();
    }

    public Applet getApplet() {
	return parentApplet;
    }

    public void setApplet(Applet applet) {
	parentApplet = applet;
	inAnApplet = true;
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
        if (inAnApplet) {
            dispose();
        } else {
            System.exit(0);
        }
    }

    private void createGUIElements() {
        defaultFont = new Font("Helvetica", Font.PLAIN, 14);
        boldFont = new Font(defaultFont.getName(), Font.BOLD,
	                     defaultFont.getSize());
        setFont(defaultFont);

    // create the images that are shared between all of the linguaPanels
    // first the flags
	MediaTracker tracker = new MediaTracker(this);
	flags = new Image[supportedLocales.length];
	flagCanvases = new FlagCanvas[supportedLocales.length];
	for (int i = 0; i < supportedLocales.length; i++) {
	    String s = "flag_" + supportedLocales[i].toString() + ".gif";
	    try {
	        URL url = getClass().getResource(s);
		flags[i] = Toolkit.getDefaultToolkit().getImage(url);
	    } catch (Exception e) {
		System.err.println("Couldn't load flag image: " + s);
		e.printStackTrace();
	    }
	    
	    tracker.addImage(flags[i], i);
	}

    // then the sound images
	soundImages = new Image[soundNames.length];
	for (int i = 0; i < soundNames.length; i++) {
	    String s = soundNames[i] + ".gif";
	    try {
	        URL url = getClass().getResource(s);
		soundImages[i] = Toolkit.getDefaultToolkit().getImage(url);
	    } catch (Exception e) {
		System.err.println("Couldn't load sound image: " + s);
		e.printStackTrace();
	    }
	    tracker.addImage(soundImages[i], i + supportedLocales.length);
	}

    // wait for all of the images to be loaded
        try {
            tracker.waitForAll();
        } catch (InterruptedException e) {
	    System.err.println("exception from tracker");
	    e.printStackTrace();
	}


    // now add the flag images to this window
	Panel p = new Panel();
	p.setLayout(new FlowLayout());
	for (int i = 0; i < flags.length; i++) {
	   flagCanvases[i] = new FlagCanvas(flags[i],
			this,
			flags[i].getWidth(this),
			flags[i].getHeight(this));
	   p.add(flagCanvases[i]);
	}
	flagCanvases[selectedFlag].setSelected(true);
	add("North", p);

    // create a card panel
	cards = new Panel();
	cards.setLayout(new CardLayout());

    // create the LinguaPanels that go into the card layout
	for (int i = 0; i < supportedLocales.length; i ++) {
	    LinguaPanel linguaPanel = null;
	    try {
		linguaPanel = new LinguaPanel(supportedLocales[i], inAnApplet,
                        	      defaultFont, boldFont, soundImages, soundNames);
	    } catch (java.util.MissingResourceException e) {
		System.out.println("Couldn't load resource(s).");
	    }

	    // add it to the card layout
	    cards.add(supportedLocales[i].getDisplayName(), linguaPanel);
	}

    // add the card layout to this window
	add("Center", cards);
    }
}
