/*
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.awt.*;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Calendar;
import java.util.Date;

import java.text.NumberFormat;
import java.text.DateFormat;

import java.net.URL;

class LinguaPanel extends Panel {

    private Label localeLabel;
    private Label localeValue;

    private Label dateLabel;
    private Label dateValue;
    private Date date;
    private DateFormat dateFormatter;

    private Label gdpLabel;
    private Label gdpValue;
    private Double gdp;
    private NumberFormat gdpFormatter;

    private Label populationLabel;
    private Label populationValue;
    private Integer population;
    private NumberFormat populationFormatter;

    private Label literacyLabel;
    private Label literacyValue;
    private Double literacy;
    private NumberFormat literacyFormatter;

    private TextArea description;

    private SoundCanvas[] soundCanvases;
    private Panel soundPanel;

    private Font defaultFont;
    private Font boldFont;

    LinguaPanel(Locale locale, boolean inAnApplet,
                Font defaultFont, Font boldFont, Image[] soundImages, String[] soundNames)
		throws java.util.MissingResourceException {

	ResourceBundle labels = ResourceBundle.getBundle("LabelsBundle", locale);
	ResourceBundle paragraph = ResourceBundle.getBundle("ParagraphBundle", locale);
	ResourceBundle numbers = ResourceBundle.getBundle("NumbersBundle", locale);

	MediaBundle flagNSoundsBundle = (MediaBundle)ResourceBundle.getBundle(
			"FlagNSoundsBundle", locale);

	flagNSoundsBundle.trackMedia((Panel)this);

    // create the GUI elements for the locale name display
        localeLabel = new Label();
        localeLabel.setFont(boldFont);
        localeValue = new Label();

        add(localeLabel);
        add(localeValue);

    // create the GUI elements for the Date display and add them to the window
	Calendar cal = Calendar.getInstance();
	date = cal.getTime();

        dateLabel = new Label();
        dateLabel.setFont(boldFont);
        dateValue = new Label();

        add(dateLabel);
        add(dateValue);

    // create the GUI elements for the gdp display and add them to the window
        gdpLabel = new Label();
        gdpLabel.setFont(boldFont);
        gdpValue = new Label();

        add(gdpLabel);
        add(gdpValue);

    // create the GUI elements for the population display and add them to the window
        populationLabel = new Label();
        populationLabel.setFont(boldFont);
        populationValue = new Label();

        add(populationLabel);
        add(populationValue);

    // create the GUI elements for the literacy display and add them to the window
        literacyLabel = new Label();
        literacyLabel.setFont(boldFont);
        literacyValue = new Label();

        add(literacyLabel);
        add(literacyValue);

    // create the sound canvases and add them to the window
	soundPanel = new Panel();
	soundPanel.setLayout(new FlowLayout());
	soundCanvases = new SoundCanvas[soundImages.length];
	for (int i = 0; i < soundCanvases.length; i++) {
	    if (inAnApplet)
	        soundCanvases[i] = new SoundCanvas(soundImages[i], this,
		    soundImages[i].getHeight(this), soundImages[i].getWidth(this),
		    flagNSoundsBundle.getString(soundNames[i]));
	    else
	        soundCanvases[i] = new SoundCanvas(soundImages[i], this,
		    soundImages[i].getHeight(this), soundImages[i].getWidth(this), null);
	    soundPanel.add(soundCanvases[i]);
	}
	add(soundPanel);

    // create a text area
	description = new TextArea(paragraph.getString("LocaleDescription"),
		7, 10, TextArea.SCROLLBARS_VERTICAL_ONLY);
	description.setEditable(false);
        add(description);

    // set text for GUI items based on locale
        localeLabel.setText(labels.getString("LocaleLabel"));
        localeValue.setText(locale.getDisplayName(locale));

        dateLabel.setText(labels.getString("DateLabel"));
	dateFormatter = DateFormat.getDateInstance(DateFormat.DEFAULT,
 						 locale);
        dateValue.setText(dateFormatter.format(date));

        gdpLabel.setText(labels.getString("GDPLabel"));
	gdpFormatter = NumberFormat.getCurrencyInstance(locale);
	gdp = (Double) numbers.getObject("GDP");
        gdpValue.setText(gdpFormatter.format(gdp));

        populationLabel.setText(labels.getString("PopulationLabel"));
	populationFormatter = NumberFormat.getNumberInstance(locale);
	population = (Integer) numbers.getObject("Population");
        populationValue.setText(populationFormatter.format(population));

        literacyLabel.setText(labels.getString("LiteracyLabel"));
	literacyFormatter = NumberFormat.getPercentInstance(locale);
	literacy = (Double) numbers.getObject("Literacy");
        literacyValue.setText(literacyFormatter.format(literacy));


	layoutGUI();
    }

    private void layoutGUI() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        setLayout(gridbag);

        c.fill = GridBagConstraints.BOTH;

    // layout locale stuff
	c.insets = new Insets(5,5,0,5);
        c.anchor = GridBagConstraints.EAST;
	c.fill = GridBagConstraints.VERTICAL;
        c.gridwidth = 1; // reset to the default
        c.weightx = 1.0; // 2 columns of equal width
        gridbag.setConstraints(localeLabel, c);

        c.anchor = GridBagConstraints.CENTER; // reset to default
        c.fill = GridBagConstraints.BOTH; //reset to app default
        c.gridwidth = GridBagConstraints.REMAINDER; // end of row
        gridbag.setConstraints(localeValue, c);

    // layout date stuff
	c.insets = new Insets(0,5,0,5);
        c.anchor = GridBagConstraints.EAST;
	c.fill = GridBagConstraints.VERTICAL;
        c.gridwidth = 1; // reset to the default
        c.weightx = 1.0; // 2 columns of equal width
        gridbag.setConstraints(dateLabel, c);

        c.anchor = GridBagConstraints.CENTER; // reset to default
        c.fill = GridBagConstraints.BOTH; //reset to app default
        c.gridwidth = GridBagConstraints.REMAINDER; // end of row
        gridbag.setConstraints(dateValue, c);

    // layout gdp stuff
        c.anchor = GridBagConstraints.EAST;
	c.fill = GridBagConstraints.VERTICAL;
        c.gridwidth = 1; //reset to the default
	c.weightx = 0.0; //reset to the default
        gridbag.setConstraints(gdpLabel, c);

        c.anchor = GridBagConstraints.CENTER; // reset to default
        c.fill = GridBagConstraints.BOTH; //reset to app default
        c.gridwidth = GridBagConstraints.REMAINDER; // end of row
        gridbag.setConstraints(gdpValue, c);

    // layout population stuff
        c.anchor = GridBagConstraints.EAST;
	c.fill = GridBagConstraints.VERTICAL;
        c.gridwidth = 1; //reset to the default
        gridbag.setConstraints(populationLabel, c);

        c.anchor = GridBagConstraints.CENTER; // reset to default
        c.fill = GridBagConstraints.BOTH; //reset to app default
        c.gridwidth = GridBagConstraints.REMAINDER; // end of row
        gridbag.setConstraints(populationValue, c);

    // layout population literacy stuff
        c.anchor = GridBagConstraints.EAST;
	c.fill = GridBagConstraints.VERTICAL;
        c.gridwidth = 1; //reset to the default
        gridbag.setConstraints(literacyLabel, c);

        c.anchor = GridBagConstraints.CENTER; // reset to default
        c.fill = GridBagConstraints.BOTH; //reset to app default
        c.gridwidth = GridBagConstraints.REMAINDER; // end of row
        gridbag.setConstraints(literacyValue, c);

    // layout image panel
	c.insets = new Insets(5,5,5,5);
        c.fill = GridBagConstraints.BOTH;
        c.gridwidth = GridBagConstraints.REMAINDER; // end of row
        gridbag.setConstraints(soundPanel, c);

    // layout text area
        c.fill = GridBagConstraints.BOTH;
        c.gridwidth = GridBagConstraints.REMAINDER; // end of row
        c.weighty = 1.0; // as tall as possible
        gridbag.setConstraints(description, c);

    }
}
