/*
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
public class NativeExample {

    private int myValue;

    static {
        Runtime.getRuntime().loadLibrary("example");
    }

    NativeExample(int v) {
        myValue = v;
    }

    native static String quote(int index) throws IllegalArgumentException;

    native int twoTimes();

    native NativeExample doubleUp();

    public static void main(String[] args) {
        String s = quote(2);
        System.out.println("Testing quote(): \"" + s + "\"");

        NativeExample ne = new NativeExample(13);
        System.out.println("Testing twoTimes() " + ne.twoTimes() + 
                           " (should be 26)");

        ne = new NativeExample(24);
        NativeExample ne2 = ne.doubleUp();
        System.out.println("Testing doubleUp() " + ne2 + " (should be 48)");
    }
}
