/*
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "MyTest.h"

jint Java_MyTest_handleError2(JNIEnv *env, jobject obj) {
	jint ret;
	jclass myClass;
	jfieldID fld;

	myClass = (*env)->GetObjectClass(env, obj);
	if (myClass == 0) return 1;
	// get fieldID
	fld = (*env)->GetFieldID(env, myClass, "myInt","Z");
	if ((*env)->ExceptionOccurred(env)) {
		printf("Caught mismatched type error.\n");
		printf("Clear the error.\n");
		(*env)->ExceptionClear(env);
		fld = (*env)->GetFieldID(env, myClass, "myInt","I");
		if ((*env)->ExceptionOccurred(env)) {
			(*env)->Throw(env, obj);
			return 9;
		}
	}
	// get field value
	ret =  (*env)->GetIntField(env, obj, fld);
	if ((*env)->ExceptionOccurred(env)) return 3;
	return(ret);
}
