/*
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "CubbyHole.h"

JNIEXPORT void JNICALL Java_CubbyHole_put(JNIEnv *env, jobject obj,
			jint value) {

   jint contents;
   jint available;
   jint ret;
   jref objref;
   jclass cubbyclass, langclass, exceptclass;
   jmethodID notifyid, waitid, exceptid;
   jobject exceptobj;
   jfieldID availid, contentid;

   langclass = (*env)->FindClass(env, "java/lang/Object");
   notifyid = (*env)->GetMethodID(env, langclass, "notify", "()V");
   waitid = (*env)->GetMethodID(env, langclass, "wait", "()V");

   cubbyclass = (*env)->GetObjectClass(env, obj);
   availid = (*env)->GetFieldID(env, cubbyclass, "available", "I");
   objref = cubbyclass;
   available = (*env)->GetIntField(env, obj, availid);
   while (available == 1) {
      (*env)->CallVoidMethod(env, obj, waitid);
      available = (*env)->GetIntField(env, obj, availid);
   }
   (*env)->SetIntField(env, obj, availid, 1);
   contentid = (*env)->GetFieldID(env, cubbyclass, "contents", "I");
   (*env)->SetIntField(env, obj, contentid, value);
   (*env)->CallVoidMethod(env, obj, notifyid);
}

