/*
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.awt.*;
import java.applet.Applet;

public class ButtonDemo extends Applet {

Button b1, b2, b3;

    public void init() {
        b1 = new Button();
        b1.setLabel("Disable middle button");

        b2 = new Button("Middle button");

        b3 = new Button("Enable middle button");
        b3.disable();

        //Add Components to the Applet, using the default FlowLayout. 
        add(b1);
        add(b2);
        add(b3);

	//Necessary when adding buttons to an already visible container:
        validate();
    }

    public boolean action(Event e, Object arg) {
        Object target = e.target;
         
        if (target == b1) { //They clicked "Disable middle button"
            b2.disable();
            b1.disable();
            b3.enable();
            return true;
        }
        if (target == b3) { //They clicked "Enable middle button"
            b2.enable();
            b1.enable();
            b3.disable();
            return true;
        }
        return false;
    }
}
